/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.TreeNodeEvent;
import apiipc.generated.events.TreeNodeEventListener;
import apiipc.generated.system.TreeNode;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeEventRegistry
extends IPCEventRegistry {
    protected Set<TreeNodeEventListener> globalListeners = new HashSet<TreeNodeEventListener>();
    protected Map<String, Set<TreeNodeEventListener>> specificObjectListeners = new HashMap<String, Set<TreeNodeEventListener>>();

    public TreeNodeEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "TreeNode";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        TreeNodeEvent.CheckChanged checkChanged = null;
        if (!string.equalsIgnoreCase("checkChanged")) {
            return;
        }
        checkChanged = new TreeNodeEvent.CheckChanged(iPCEventLTV);
        for (TreeNodeEventListener object : this.globalListeners) {
            object.handleEvent(checkChanged);
        }
        System.out.println("UUID = " + checkChanged.objectUUID);
        Set<TreeNodeEventListener> set = this.specificObjectListeners.get(checkChanged.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TreeNodeEventListener treeNodeEventListener = (TreeNodeEventListener)iterator.next();
                treeNodeEventListener.handleEvent(checkChanged);
            }
        }
    }

    public void addListenerFiltered(TreeNodeEventListener treeNodeEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("checkChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(treeNodeEventListener);
    }

    public void addSpecificListenerFiltered(TreeNodeEventListener treeNodeEventListener, TreeNode treeNode, List<String> list) throws IOException {
        UUID uUID = treeNode.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<TreeNodeEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<TreeNodeEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "checkChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(treeNodeEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(TreeNodeEventListener treeNodeEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("checkChanged");
                this.globalListeners.remove(treeNodeEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(TreeNodeEventListener treeNodeEventListener, TreeNode treeNode, List<String> list) throws IOException {
        UUID uUID = treeNode.getObjectUUID();
        String string = uUID.toString();
        Set<TreeNodeEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "checkChanged");
                set.remove(treeNodeEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(TreeNodeEventListener treeNodeEventListener) throws IOException {
        this.addListenerFiltered(treeNodeEventListener, null);
    }

    public void addListener(TreeNodeEventListener treeNodeEventListener, TreeNode treeNode) throws IOException {
        this.addSpecificListenerFiltered(treeNodeEventListener, treeNode, null);
    }

    public void removeListener(TreeNodeEventListener treeNodeEventListener) throws IOException {
        this.removeListenerFiltered(treeNodeEventListener, null);
    }

    public void removeListener(TreeNodeEventListener treeNodeEventListener, TreeNode treeNode) throws IOException {
        this.removeSpecificListenerFiltered(treeNodeEventListener, treeNode, null);
    }
}

